# Radio Station

Radio Station lets you build and manage a Show Schedule for a radio station or Internet broadcaster's WordPress website. 

## Plugin Details

Contributors: tonyzeoli, majick

Donate link: https://netmix.co/donate

Tags: dj, music, playlist, radio, shows, scheduling, broadcasting

Requires at least: 3.3

Tested up to: 6.8.2

Stable tag: 2.5.14

License: GPLv2 or later

License URI: http://www.gnu.org/licenses/gpl-2.0.html


## Description

[Live Demo](https://demo.radiostation.pro/) | [Documentation](https://radiostation.pro/docs/) | [Support](https://wordpress.org/support/plugin/radio-station/) | [**Upgrade to PRO**!](https://radiostation.pro/pricing/)


#### RADIO STATION by netmix®† - THE BEST WORDPRESS PLUGIN FOR BROADCASTERS!

**Radio Station** *by netmix®* is the most comprehensive WordPress plugin for broadcasters of all types, to manage your Show schedule and play your audio stream on a WordPress website. Thousands of broadcasters worldwide use **Radio Station** *by netmix®* to manage their schedules, showcase their shows, attach playlists, and feature broadcast teams.

Used by thousands of stations worldwide, **Radio Station** *by netmix®* is the most popular Radio Station plugin for WordPress and is used by broadcasters of all types.

*Radio channels* and *television networks* can use it to showcase their existing program schedule online, *podcasters* to announce upcoming episode drops, *streamers* to let their fans know of their next live webcast, *social audio moderators* to let their group know of the next meetup, and for other *online curators* to schedule content for their audience base.


#### SO WHAT DOES RADIO STATION BY netmix® DO?

At its core the plugin adds a **Show** custom post type, schedulable blocks of time that contain a description, a weekly shift repeater field, uploadable images and other meta information. This lets you easily and instantly display a full show **Schedule** on the front end of your site in one of three built-in schedule views. (It also supports adding **Overrides** for handling specific dates and times that can be fully or partially linked to existing shows.)

You can also create detailed track **Playlists** and associate them with a Show, or assign blog posts as **Related Posts** to a Show. Users can be given a plugin role of **Host** or **Producer** with edit privelages when assigned to a Show. **Genre** and **Language** taxonomies are available to group and filter your Shows. **Automatic Pages** are available for your Schedule and all plugin record lists.

**PLUS** we’ve built in a *NEW* **Stream Player** so that your audience can listen to your broadcast while navigating your site. You can also quickly display the **Current Show**, **Upcoming Shows**, **Current Playlist**, **Radio Time** and **Show Lists**. All are available for easily customizable display as *Blocks*, *Widgets* and/or *Shortcodes*!

[Want more? Click here to find out about **Radio Station PRO**](https://radiostation.pro/).


#### RADIO STATION BY netmix® FEATURES

**Radio Station** *by netmix®* is the most feature-packed WordPress plugin for broadcasters today. With features that address both station and audience use cases, your team will be eager to add content your audience will find more engaging. The improved user experience provided by our plugin will help your station website increase visitor time spent on the site, which a critical metric your advertising partners will be keen to know.

**Key Show Features**:

- Add **Shows** with Weekly Shifts
- Automatic Shift **Conflict Checker**
- Add Show **Description** and **Images**
- Add Timeslot **Overrides** (linkable to Shows)
- Assign **Host** and **Producer** user roles
- Assign **Genre** and **Language** Terms
- Assign Blog **Related Posts** to Shows
- Add **Playlists** and **Latest Audio** to Shows
- Show Page Content Layout Options
- Display Station/Show Phone Number
- Denote Encore Presentations (Repeats)

**Key Station and Schedule Features**:

- **3 Schedule Layouts**: Table, Tabs, List
- **Automatic Pages** for Schedule and Archives
- Full Schedule and Show **Data API**
- Set Station Name and Logo Image
- Set and Display Station Timezone
- Set Main Station Language
- Automatic Current Show Highlighting
- Genres Highlighted by User Selection
- Converts Show Times to Listener Timezone

**Key Stream Player Features**:

- Works with virtually any Stream source
- Compatible with Shoutcast, Icecast, Live365, and Radio.co
- 3 In-built Audio Scripts: Howler, Amplitude, jPlayer
- 7 Streaming Formats Support: MP3, AAC/M4A, OGG, OGA, WebM, RTMPA, OPUS
- Light and Dark Player Themes
- 3 Default Player Button Styles
- Added via Shortcode, Widget or Block


#### WIDGETS, SHORTCODES, GUTENBERG BLOCK SUPPORT

All of the following **Shortcodes** are available as classic **Widgets**, and as of version 2.5.0 they are also available as **Blocks** for the Gutenberg editor:

- Stream Player
- Show Schedule
- Show Lists
- Current Show
- Upcoming Shows
- Current Playlist
- Radio Clock

Need the best for your channel? Further improvements and extra features can be found in [**Radio Station PRO**](https://radiostation.pro/pricing/).


#### BOOST YOUR SEO WITH RADIO STATION BY netmix®

We strongly believe in SEO and we're confident that managing your Show schedule with **Radio Station** *by netmix®* will give your SEO a boost! Here's why...

When it comes to SEO, there's only one thing better than great content - and that's great content that's *well organized!* With **Radio Station**, your website is immediately optimized for search through the addition of the **Shows** custom post type, giving you the best natural placement for your Show description and content. On top of this, you benefit directly from the internal linking of **Shows** with **Playlists**, **Related Posts**, and **Genre** / **Language** taxonomies. (And in [**Radio Station PRO**](https://radiostation.pro) this is extended even further with profile pages for **Hosts* and *Producers**, and **Episodes** with **Guest** / **Topic** taxonomies!)

Combined this with a WordPress SEO plugin (such as All In One SEO Pack), this kind of keyword-rich organized content will boost your ranking in search results. You just need to make sure you add the content for all your Shows! *netmix®* founder Tony Zeoli had a strong working relationship with the founding team at All in One SEO and used it with **Radio Station** to boost client's SEO even before taking this plugin over. We know how important SEO is to your channel - so your audience can find the Shows and related content they care about - ***yours!***

**SPECIAL BONUS!** Once installed, broadcasters who power their station’s WordPress websites with **Radio Station** *by netmix®* may add their station listing to our [Netmix.com](https://netmix.com) Broadcasters Directory, making your schedule instantly available to a new audience, and giving you a free high-quality backlink from a legacy domain (originally registered in 1995!) ou can also receive a Featured Listing in the Directory by supporting the further development of the free, open-source version of this plugin via [Patreon](https://www.patreon.com/radiostation).



#### WANT MORE? UPGRADE TO RADIO STATION PRO!

In the course of improving the free version, we’ve tracked a plethora of great features and developed them for inclusion in **Radio Station PRO**. The Pro version amps up your broadcast website with numerous additional **Schedule Improvements** such as *extra schedule views*, *recurring timeslots*, *auto-refreshing widgets*, and a *visual schedule editor!* It also gives you **New Content Features** like *show Episodes and Ssegments*, *Topic and Guest taxonomies*, and *page builder modules!*

**PLUS**, building on our jamming free **Stream Player**, we’ve created our own *innovative page transition technology* and then combined it with a purpose-built sticky **Sitewide Player Bar**, allowing your listeners to navigate while continuing to play your audio ***uninterrupted***! This is a real game-changer for your listener's online experience of your site. The Player Bar includes *animated live track metadata*, *responsive display sections* and *extended color and button themes*.

[Click here to find out more about Radio Station PRO](https://radiostation.pro/).


#### RADIO STATION PRO BY netmix® FEATURES

**Radio Station PRO** takes your broadcast website to the next level with a full rack of **Scheduling Enhancements** and **Content Tools** you can use to satisfy and impress your visitors! **ALSO** in Pro, we’ve added even more improvements to our Stream Player, including the ability to activate a **Sitewide Player Bar** with smooth page transitions, allowing your audience to browse your site content while listening to your audio stream playback ***uninterrupted!***

**Key Scheduling Features**:
- Front End **Visual Schedule Editor**
- Additional Schedule **Calendar and Grid Views**
- **Multi-View Switching** on Show Schedule
- Schedule Previous/Next **Week Shifting**
- Listener **Timezone Selection** Switching
- **Recurring Override** Timeslots
- Show and Schedule **Import/Export**

**Key Content Features**:

- Host and Producer **Profile Pages**
- Easy **Role Assignment Interface**
- Dynamic **Auto-refresh Widgets**
- **Show Episodes** linked to Shows
- Add **Topic** and **Guest** Terms to Episodes
- Automatic **Team Display** for Show Pages
- **Social Network Icons** (for Shows & Profiles)
- Page Builder Modules (**Elementor** & **Beaver Builder**)
- All Pro Settings added to Gutenberg **Blocks**

**Key PRO Player Features**:

- **Persistent Sitewide Player Bar**
- Single Page Application **Fading Transitions**
- Station, Player/Track and Show **Bar Sections**
- **Responsive Display** Section Navigation
- Animated **Track Metadata** Display (via Stream)
- 12 Extra Player **Button Themes**
- Bar and Player **Advanced Color Styling**
- Optional **Popup Player** Button
- Player Page Builder Module (**Elementor** & **Beaver Builder**)
- Pro Player Settings added to **Player Block**

[Click here to Upgrade to **Radio Station PRO**](https://radiostation.pro/pricing/).


#### DOCUMENTATION AND SUPPORT

As there is a lot you can do with **Radio Station** *by netmix®*, we’ve made an effort to provide *complete* [Radio Station plugin Documentation](https://radiostation.pro/docs/). To get you going faster, you can find a [Quickstart Guide](https://radiostation.pro/docs/quickstart/) there (as well as in the section below.) Documentation for PRO Features can be found within the existing documentation, as well as indexed separately [here](http://radiostation.pro/docs/pro/). 

You can see some example displays from the plugin via the Screenshots section below, and *full live examples* for both Free and PRO features are available on the [Radio Station Plugin Demo Site](https://demo.radiostation.pro). If you are ready to upgrade or want to find out more about **Radio Station PRO** then [Click Here](https://radiostation.pro/pricing/).

For free version plugin **Support**, you can ask in the [WordPress Plugin Support Forum](https://wordpress.org/support/plugin/radio-station/). Please give 24-48 hours to answer support questions. Alternatively (and preferably) you can submit bugs, enhancement and feature requests directly to our [Github Repository Issues](https://github.com/netmix/radio-station/issues). For **PRO Support**, please [Submit a Support Ticket](https://radiostation.pro/support/).


#### QUICKSTART GUIDE

Once you have installed and activated the **Radio Station** plugin on your WordPress site, your WordPress Admin area will now have a new menu item titled Radio Station with submenu page items. Note if you have a specific question, you can check out the [Frequently Asked Questions](https://radiostation.pro/docs/faq/) as you may find the answer there.

Firstly, you can visit the Plugin Settings screen to adjust the default [Plugin Options](https://radiostation.pro/docs/options/) to your liking. Here you can set your Radio Timezone and Language, along with your Streaming URL and Station Logo, as well as other global plugin settings. Also from this Settings page you can assign [Automatic Pages](https://radiostation.pro/docs/display/#automatic-pages) and Views for your Program Schedule display and for other plugin post type archive displays. But first you will want to add some Shows to display in your Schedule!

To do this, click on Shows in the adimn submenu, then on "Add a New Show" at the top. Give it a Shift timeslot and a description and then click Publish. Then view the Show page by clicking the Show Permalink under the show title. (Depending on your Theme, you may wish to adjust the [Templates](https://radiostation.pro/docs/display/#page-templates) used.) You can also assign different [Images](https://radiostation.pro/docs/display/#images) to Shows. 

Next, have a look at your Program Schedule page to see the Show displayed there also. Keep adding Shows until you have your Schedule filled in! You can also add schedule Overrides for specific date and time blocks only. For ease of use they can be fully or partially linked to an existing Show. You can further [Manage](https://radiostation.pro/docs/manage/) your Shows and other Station data via the WordPress Admin area.

Now you may want to give some users on your site some plugin [Roles](https://radiostation.pro/docs/roles/). (Note that while the default interface in WordPress allows you to assign a single role to a user, it also supports multiple roles, but you need to add a plugin to get an interface for this.) Giving a user role of Host/DJ or Producer to a user will allow them to be assigned to a Show on the Show Edit Page and allow them to edit that Show. You can also assign the Show Editor role if you have someone who needs to edit all plugin post types without being a site Administator.

There are a number of [Widgets](https://radiostation.pro/docs/widgets/) you can add to your site via your *Appearance -> Widgets* admin submenu. These are also available as [Shortcodes](https://radiostation.pro/docs/shortcodes/) and [Blocks](https://radiostation.pro/docs/widgets/#radio-station-blocks). There are widgets for the Current Show or Playlist, and another to display Upcoming Shows. In this way you can also add a Stream Player, Radio Clock, Schedule View or Show List anywhere you like.

Radio Station has several in-built [Data](https://radiostation.pro/docs/data/) types. These include [Custom Post Types](https://radiostation.pro/docs/data/#custom-post-types) for Shows, Schedule Overrides and Playlists. There are [Taxonomies](https://radiostation.pro/docs/data/#taxonomies) for Genres and Languages. You can override most data values and display output via custom [Data Filters](https://radiostation.pro/docs/filters/#data-filters) throughout the plugin. We have also incorporated a [Data API](https://radiostation.pro/docs/api/) in the plugin available via REST and/or WordPress Feeds, and this data is accessible in JSON format. 

This plugin is under active development and we are continuously working to enhance the free version available on [WordPress.Org](https://wordpress.org/plugins/radio-station/), as well as creating new feature additions for [Radio Station Pro](https://radiostation.pro/). Check out the [Roadmap](https://radiostation.pro/docs/roadmap/) if you are interested in seeing what is coming up next!


#### CONTRIBUTION

We are grateful to Nikki Blight for her contribution to creating and developing this plugin for as long as she could maintain the codebase. As of June 22, 2019, Radio Station is managed by [Tony Zeoli](https://profiles.wordpress.org/tonyzeoli/) with [Tony Hayes](https://profiles.wordpress.org/majick/) as lead developer and other contributing committers to the project.

If you are a WordPress developer wanting to contribute to Radio Station, please join the team and follow plugin development on [Github](https://github.com/netmix/radio-station) and submit Issues and Pull Requests there. You can see the current progress via the Projects tab, and the [Roadmap here](https://radiostation.pro/docs/roadmap/). Or if you would prefer to get involved even more substantially, please [Contact Us via Email](mailto:info@netmix.com) and let us know what you would like to do.


#### UPGRADING TO RADIO STATION PRO

Love Radio Station and ready for more? As the free version develops, we have also been working hard to introduce new features to create a Professional version to "level up" the plugin to make your channel's schedule and player even more useable and accessible for all your listeners! 

[Click here to learn more about Radio Station Pro](https://radiostation.pro/).


## Installation

1. Upload plugin .zip file to the `/wp-content/plugins/` directory and unzip.
2. Activate the plugin through the 'Plugins' menu in the WordPress Admin
3. Alternatively search for Radio Station via the WordPress admin Add New plugin interface and install and activate it there.
4. Give any users who need access to the plugin the role of "Host", "Producer" or "Show Editor". Assigning These roles gives publish and edit access to the plugin's records.
5. Create Shows, add Shifts to them, and assign Images, Genres, Languages, Hosts and/or Producers.
6. Add Playlists to your Shows or assign posts to Shows as needed.
7. Go to your admin Appearance -> Widgets page to add and configure Current and Upcoming Show Widgets, and any other desired plugin widgets.
8. See the QuickStart Guide above for more detailed instructions of what else is available.


## Frequently Asked Questions

### Getting Started

##### How do I get started with Radio Station (Free or PRO)?

Read the [Quickstart Guide](./index.md#quickstart-guide) for an introduction to the plugin, what features are available and how to set them up.

##### Where can I find the full Radio Station documentation (Free or PRO)?

The latest documentation [can be found online here](https://radiostation.pro/docs/). Documentation is also included with the currently installed version via the Radio Station Help menu item located under the Radio Station admin menu. You can find the Markdown-formatted files in the `/docs` folder of the [GitHub Repository](https://github.com/netmix/radio-station/docs/) and in the `/docs` folder of the plugin directory. 

##### How do I get support for Radio Station (Free or PRO)?

For Radio Station customers using the free, open-source version of our plugin, you can contact us via [our support channel in the WordPress support forums here](https://wordpress.org/plugins/support/radio-station). If you have any bug reports or feature suggestions please [open an issue on our Github repository](https://github.com/netmix/radio-station/) For Radio Station PRO subscribers, you can email us at support@radiostation.pro and someone will respond to your inquiry within 12 to 124 hours. All support inquiries will be handled in the order they are received. Before contacting support or opening an issue, make sure you check for conflicts by disabling all of your plugins and re-enabling them one at a time to ascertain which plugin is conflicting with Radio Station. Note that Radio Station PRO works as an addon to Radio Station, so deactivating it will disable the PRO features until you reactivate it.

#####  How can I report security bugs?

You can report security bugs through the Patchstack Vulnerability Disclosure Program. The Patchstack team help validate, triage and handle any security vulnerabilities. [Report a security vulnerability.](https://patchstack.com/database/vdp/radio-station)

##### Can I try Radio Station PRO before I purchase the plugin?

Yes, you can trial Radio Station PRO for up to 14 days. You are required to set a credit or debit card when you sign up for the free trial and can cancel any time before the trial ends. The credit or debit card on file will be charged automatically once the trial expires 14 days from the date your free trial began. [Click here to start your trial.](https://radiostation.pro/pricing)


### Account and Billing

##### How do I access my Radio Station PRO account?

We have partnered with Freemius who provide an integrated subscription and upgrade system for WordPress plugin developers. When you purchase Radio Station PRO, you will receive email instructions to create your account, which contain a link to the [Freemius User Dashboard here](https://users.freemius.com/login). While you can see your account details by navigating to WordPress Dashboard > Radio Station > Account, logging into the Freemius Dashboard will give you full control over your account.

##### Can I request a refund for Radio Station PRO?

We offer a 30 day, moneyback guarantee. If you are not satisfied with Radio Station PRO within the 30 day period, we will issue a full refund, no questions asked. Once the 30 day period is exhausted refunds are not available.

##### How do I cancel my Radio Station PRO subscription?

Login to your [Freemius User Dashboard](https://users.freemius.com/login) and navigate to Renewals & Billing to cancel your Radio Station PRO subscription. When you cancel your subscription, your account will stay active for the remainder of the billing period. Once your subscription is cancelled, you will lose access to PRO customer support and any future upgrades, bug fixes and feature additions. Radio Station (free) will continue to operate normally.


### Plugin Usage

##### How do I schedule a Show? 

Simply create a new show via Add Show in the Radio Station plugin menu in the Admin area. You will be able to assign Shift timeslots to it on the Show edit page, as well as add the Show description and other meta fields, including Show images.
In order to schedule a Show, a Show must be added and available to accept schedule entries. If this is your first time using Radio Station, create a new show via the Add Show item in the Radio Station menu in your WordPress Admin screen. You can assign Shift timeslots to your new Show or pre-existing Show on the Show edit page, as well as add a Show description and other meta fields, including Show images.

##### How do I display a full schedule of my Station's shows? 

Navigate to the plugin Settings page via the Radio Station menu in your WordPress Admin screen and then click the Pages tab. There you can select the Page on which to automatically display the schedule, as well as which View to display (a Table grid by default.) Alternatively, you can use the shortcode `[master-schedule]` on any page (or post.) This option allows you to use additional shortcode attributes to control what is displayed in your Schedule (see [Master Schedule Shortcode Docs](./Shortcodes.md#master-schedule-shortcode) )

##### What if I want to schedule a special event or one-off schedule change?

If you have a one-off event that you need to show up in the Schedule and Widgets, you can create a Schedule Override by navigating to WordPress Dashboard > Radio Station > Schedule Overrides > Add New. This will allow you to set aside a block of time on a specific date, and when the Schedule or Widget is displaying that date, the override will be used instead of the normally scheduled Show. You can also link an Override to an existing Show, and partially update any Show information to be overridden. (Note that Schedule Overrides will not display in the old Legacy Table/Div Views of the Master Schedule.) In the Free version, if an Override needs to apply to multiple dates, you must schedule each time slot individually. In the PRO version, you can repeat the Override via day periods or monthly recurrences. To enable recurring overrides, [Upgrade to Pro here](https://radiostation.pro/pricing/)

##### How do I change the Show Image displayed in the widgets and schedule? 

The schedule, widgets and show page will display whichever avatar is assigned to the show on the Show Edit screen. Navigate in the WordPress Dashboard to Radio Station -> Shows and locate the Show you want to add/edit the Avatar for in the Shows list. Edit the Show then simply set a new image for the Show.

##### How do I style how the plugin displays content on the front end of my site?

The default styles for Radio Station have intentionally kept fairly minimal so as to be compatible with most themes, so you may wish to add your own CSS styles to suit your site's look and feel. You can add these styles via Theme Customizer's Additional CSS setting. You can also add your own `rs-custom.css` file to your Child Theme's directory, and Radio Station will automatically detect the presence of this file and enqueue it. Either way you can add more specific selectors with rules that modify or override the existing styles. You can find the base styles in the `/css/` directory of the plugin. 


### Widgets, Blocks and Shortcodes

##### What Widgets/Blocks are available with this plugin?

The following Widgets are available to add via the WordPress Appearance -> Widgets page:

- Streaming Player
- Current Show
- Upcoming Shows
- Current Playlist
- Radio Clock
 
Since 2.5.0, these widgets are now also available as Gutenberg Blocks. See the [Widget Documentation](./Widgets.md) for more details on these Widgets.

##### Do the Widgets reload automatically?

In the free version of Radio Station, the Current Show, Upcoming Shows, and Current Playlist widgets can display a countdown, but do not refresh automatically. To enable auto-reloading of these widgets, so that they refresh exactly at a Show’s changeover time, [upgrade to Radio Station PRO](https://radiostation.pro/pricing/).

Current Show, Upcoming Shows and Current Playlist widgets do not refresh automatically in the Free version of Radio Station. This functionality is only available in our Pro version so widgets refresh exactly at a Show's changeover time. To enable s refresh exactly at Show changeover times. To enable auto-refresh widgets [upgrade to Radio Station PRO](https://radiostation.pro)

##### What Shortcodes are available in Radio Station?

See the [Shortcode Documentation](./Shortcodes.md) for more details and a full list of possible Attributes for these Shortcodes:

* `[master-schedule]` - Master Program Schedule Display
* `[current-show]` - Current Show Widget
* `[upcoming-shows]` - Upcoming Shows Widget
* `[current-playlist]` - Current Playlist Widget
* `[shows-archive]` - Archive List of Shows
* `[genres-archive]` - Archive List of Shows sorted by Genre
* `[languages-archive]` - Archive List of Shows sorted by Language
* `[overrides-archive]` - Archive List of Schedule overrides
* `[playlists-archive]` - Archive List of Show Playlists

(Note old shortcode aliases will still work in current and future versions to prevent breakage.)

##### Do you include Page Builder support?

The free version of Radio Station includes support for classic Widgets and Gutenberg Blocks. The same widgets are available as modules for Elementor and Beaver Builder in the Pro version, along with additional styling options for each module. To enable these page builder modules, [upgrade to PRO here](https://radiostation.pro/pricing/).


### User Plugin Roles

##### How do I assign a User as the Host or Producer to one or more Shows? 

You can to assign the Host or Producer roles to any WordPress User by accessing the User editor located under WordPress Dashboard -> Users. Search for or navigate to the User you want to assign as a Host or Producer, then click Edit to open the Edit screen for that User. Find the Roles dropdown menu and select from the Role options provided. Choosing either Host or Producer grants the User that role. You can then assign that User to single or multiple Shows via the Show Edit page. A Host or Producer only has permissions to Edit the Show(s) they are assigned to. The Pro version includes an additional Role Editor interface where you can assign the plugin Roles to any number of users at once. To enable the Role Editor interface, [upgrade to PRO here](https://radiostation.pro/pricing/).

##### How do I grant users other than Administrator and DJ roles permission to edit Shows and Playlists?

There are a number of different options depending on what your goals are. Assigning a user as a Host or Producer to a Show will allow that User to edit it (and it's Playlists.) You could also assign a single User as the Author of a Show/Playlist. If you’d like to give a user that isn't a site Administrator permissions for all Radio Station records, you can assign them the Show Editor role that was created for this purpose. This may help keep clear lines of separation for editorial responsibility over your content. You can find more information on roles in the [Roles Documentation](https://radiostation.pro/docs/Roles/).

##### How do I use a different image from the Gravatar for a Host/Producer?

If you prefer not to use WordPress-owned, Gravatar.com for your User profile images,  you'll need to install a plugin that allows you to add a different image to your Host/Producer's user account. You can search for a free plugin in the WordPress plugin repository at WordPress.org. As there are a number of plugins that do this already, it's mostly out of the scope of this plugin. However, in our Pro version, you can create separate Profile pages to showcase each of your Hosts and Producers, to which you can assign profile images that appear on those. To enable Profile pages, [upgrade to PRO here](https://radiostation.pro/pricing/).


### Languages and Translations

##### What languages other than English is the plugin available in? 

As of April 1st, 2023, known languages include the following: 

* Albanian (sq_AL)
* Dutch (nl_NL)
* French (fr_FR)
* German (de_DE)
* Italian (it_IT)
* Russian (ru_RU)
* Serbian (sr_RS)
* Spanish (es_ES)
* Catalan (ca)

##### Can Radio Station be translated into my language?

You may translate the plugin into any other language supported by the WordPress translation engine. Please visit our [Translate project page](https://translate.wordpress.org/projects/wp-plugins/radio-station/) for all translations and for further instructions. Note that for ease of translation the Free version contains any extra text strings from the PRO version. The `radio-station.pot` file is located in the `/languages` directory of the plugin. If you do add a translation for your preferred language, please send or notify us of the completed translation to `info@netmix.com`. We'd love to include it.


### Troubleshooting

##### Why aren't all my Shows displaying in the Schedule?

Did you remember to check the "Active" checkbox for each Show? If a Show is not marked active, the plugin assumes that it's not currently in production and it is not shown on the Schedule. A Show will also not be shown if it has a Draft status or has no active Shifts assigned to it.

##### I'm seeing a 404 Not Found error when I click on the link for a Show! 

Try re-saving your site's permalink settings via Settings > Permalinks. WordPress sometimes gets confused with a new custom post type is added. Permalink rewrites are automatically flushed on plugin activation, so you can also just deactivate and reactivate the plugin to regenerate your site's permalinks.

##### Where is my data stored? Can I export my data?

Radio Station is stores your site's settings and all post type data in your WordPress MySQL database on your webhost. You can export your data using WordPress Dashboard -> Tools -> Export feature, or use Radio Station PRO’s Export feature located at WordPress Dashboard -> Import/Export. Our import/export feature works with YML and not XML, which is the standard WordPress format.

##### Why can't Show Hosts or Producers can't edit a Show page?

The only Hosts and Producers that may Edit a Show are the ones assigned as Host(s) or Producer(s) to that specific Show in the respective user selection menus. This is to prevent Hosts/Producers from editing other Shows managed by different Hosts/Producers without permission. If you need a user other than Administrator to be able to edit all Shows you can assign them a Show Editor role.


### Integrations

##### Can I use this plugin for Podcasts?

While the plugin is not specifically geared toward Podcasting, which is not live programming, some podcaster's have used Radio Station to let their subscribers know when they publish new shows.

##### Can I use this plugin for TwitchTV, Facebook Live, YouTube or Clubhouse shows?

Sure, there's no reason why you couldn't use the plugin to display a show schedule on a WordPress site for those services. Unfortunately, we are not currently syncing events from these platforms, but may do so in the future. While there may be APIs available from the larger services, Clubhouse does not yet have a public API, so scheduled rooms can't be automated to the Radio Station show scheduling system.

##### I use Google Calendar to print a show schedule online. Can I import/sync my Google Calendar with Radio Station?

We haven't built an interface between Google Calendar and Radio Station just yet, but it's on our radar to do so in the foreseeable future.

##### Can I import Show data from Pro.Radio or the JOAN (Jock on Air Now) plugin?

We do not have a method of importing data directly from JOAN or Pro.Radio


### Development Versions

##### How do I install the latest Development version for testing?

If you are having issues with the plugin, we may recommend you install the development version for further bugfix testing, as it may contain fixes that are not yet released into the next stable WordPress version. It is recommended you do this on a staging site. Instructions:

1. Visit the `develop` branch of the Radio Station Github repository at:
`https://github.com/netmix/radio-station/tree/develop/`
2. Click on the green "Code" button and select Download a ZIP.
3. Unzip the downloaded file on your computer and upload it via FTP to the subdirectory of your WordPress install on your web server: `/wp-content/plugins/radio-station-develop/`
4. Rename the subdirectory `/wp-content/plugins/radio-station/` to `/wp-content/plugins/radio-station-old/`
5. Rename the subdirectory `/wp-content/plugins/radio-station-develop/` to `/wp-content/plugins/radio-station/`

Then upload to WordPress via the plugin installer as normal.
Note that it will install to /wp-content/plugins/radio-station-develop/, and because of this won't overwrite your existing installation, so you'll need to deactivate that before activating the development version.

You can now visit your site to make sure nothing is broken. If you experience issues you can reverse the folder renaming process to activate the old copy of the plugin. If the new development version works fine, at your convenience you can delete the `/wp-content/plugins/radio-station-old/` directory.

Alternatively, if you want to do this from your WordPress Plugin area, you can upload the development Zip file from your Plugins -> Upload page. This will install it to `/wp-content/plugins/radio-station-develop/`. You can then deactivate the existing Radio Station plugin from you Plugins page and then activate the development version. (You can tell them apart on the plugins page via their version numbers. Official releases are 2.x.x, only development releases have the extra digit 2.x.x.x) Again, if you experience issues, you can deactivate the development version and reactivate the old version.

##### What about Pro Beta Version Testing?

We are constantly improving and adding new features to [Radio Station Pro](https://radiostation.pro/pricing/). Periodically we will release a Beta version to test out a new feature (or fix) out before it is officially released. If you have a Pro license, you can access these cutting edge Pro Beta version releases in two ways:

1. Download the Beta versions by logging in to your [Freemius User Dashboard](https://users.freemius.com/login). and navigating to the "Downloads" section. You will see a dropdown list of all the Radio Station Pro releases, including beta ones.
2. Enable the Beta program option from your Radio Station Account page in your WordPress site's Admin area, and the latest Beta version will then be available as an update.

**Important Note**: As we are developing the Free and Pro versions in tandem, the latest Pro Beta may require you to install a development version of the Free plugin for it to work. Please see the previous section for how you can install the development version from Github (if the required version is not yet available via the WordPress repository.)

We recommend you test these on a Staging site (or a development copy of your live site.) This way you can make sure there are no significant bugs before using it on a production site. Of course, please be willing to [report any bugs](https://github.com/netmix/radio-station/issues) that you do find so we can ensure they are not present in the next official release.

## Changelog

[View Full Changelog](./CHANGELOG.md)


## Upgrade Notices

#### 2.5.0
* Radio Station Blocks for Gutenberg Block Editor!
* https://radiostation.pro/radio-station-2-5-0-release-with-blocks/
* Refactored Schedule Engine Class
* Improved translations and sanitization
* Numerous bugfixes and improvements
* Escape debug output security fix

#### 2.4.0
* Radio Station Stream Player Widget!
* https://radiostation.pro/radio-station-update-version-2-4-0-with-streaming-audio-player/

#### 2.3.3.9
* Multiple Dates and Times for Schedule Overrides!
* https://netmix.com/radio-station-2-3-3-9-release-announcement/
* Link Override to Show with Selective Fields
* Automatic Visitor Showtime Conversion and Display
* Language Archive Shortcode for Shows
* Various Bugfixes and Improvements
* Updated Freemius SDK and Plugin Loader

#### 2.3.3.8
* Updated Plugin Panel Library
* Added Stream Format selection setting
* Added Station email address setting with default display option
* Added Section order filtering for Master Schedules and Widgets
* Added Show image alignment attribute to Schedule Tabs View

#### 2.3.3.7
* Updated Freemius SDK and Plugin Loader libraries
* Added Station phone number setting with default display option
* Added Schedule classes for Shows before and after current Show
* Multiple Related Show Post assignment edit and link fixes
* Bugfixes for permissions, main language and shift checker

#### 2.3.3.6
* Updated Freemius SDK and Plugin Loader libraries
* Added Station phone number setting with default display option
* Added Schedule classes for Shows before and after current Show
* Multiple Related Show Post assignment edit and link fixes
* Bugfixes for permissions, main language and shift checker

#### 2.3.3.5
* Ability to assign Post to relate to multiple Shows
* Added Admin Filtering, Bulk Edit and Quick Edit interfaces
* Fixes for Schedule display left/right shifting on mobiles
* Fixes for starting Schedule display on different day

#### 2.3.3.3
* Current and Upcoming Shows Widget Fix

#### 2.3.3.2
* Minor Bugfix Update

#### 2.3.3 =
* Important Bugfix Update
* Fix to conflict with plugins using AJAX save_post calls
* Improved accuracy for responsive table/tab Schedule views
* Added colour improvements to Show Shift interface
* Fix to calculate Current Show (transient no longer used)

#### 2.3.2 =
* Improved Times, AJAX Loading and Bugfix Update 
* https://netmix.com/radio-station-2-3-2-release/
* Radio Clock Widget and Widget AJAX Loading
* AJAX Saving of Show Shifts and Playlist Tracks
* Automated current Show schedule highlighting
* Improved timezones, overrides, shift checking and more

#### 2.3.1 =
* Bugfix Update and Announcing New Netmix Station Directory!
* https://netmix.com/announcing-new-netmix-directory/
* Including minor fixes to major update release
* Option to ping Netmix Directory on show updates

#### 2.3.0
* Major Update including many new features, enhancements and fixes!
* https://netmix.com/radio-station-2-3-0-release/
* Revamped Templates, Master Schedule Views, Shortcodes and Widgets
* Added Admin Options, REST API Routes and Shift Conflict Checking
* Added Show Producers, Language Taxonomy, Timezones and Countdowns
* Improved User Roles, Show Images, Post Type Supports + much more!

#### 2.2.8
* Stable version before major update, including many fixes from 2.2.0 onwards 
* Fix to remove strict type checking (introduced 2.2.6) which fixes DJ can't edit Show

#### 2.2.0
* WordPress coding standards refactoring for WP 5 (thanks to Tony Hayes @majick777)

#### 2.1.2
* Compatibility fix for Wordpress 4.3.x - Updated the widgets to use PHP5 constructors instead of the deprecated PHP4 constructors.

#### 2.1
* General code cleanup, 4.1 compatibility testing, and changes for better efficiency.

#### 2.0.0
* Major code reorganization for better future development
