# Radio Station Plugin Roadmap

***

Since taking over the development of the free Radio Station plugin in June 2019, we've made massive improvements to every aspect of the project. Two years later, we released the Pro version and have continued to update and improve both versions, adding innovative features as we go. 

The below table is a simplified overview to help keep track of all the major different features in Free and Pro, both those that we've added already and planned upcoming features. (If you want to contribute ideas or suggestions, please do so by opening a [Github Issue](https://github.com/netmix/radio-station/).)

If you are interested in testing cutting edge features in development for this next release, read about [Installing the Development Version](./FAQ.md#how-do-i-install-the-latest-development-version-for-testing) and [Pro Beta Version Testing](./#pro-beta-version-testing).

For minor release notes, see the [Radio Station Changelog](./CHANGELOG.md)
(Note: The Radio Station Pro changelog can be found in the plugin's `readme.txt`)

Normal = Feature Completed

*italics* = Upcoming Feature

**bold** = Next Major Feature(s)


| Free | Version | Pro | Version |
| --- | --- | --- | --- |
| SCHEDULE |
| Scheduler with Conflict Checker | 2.3.0 | with Visual Schedule Editor | 2.3.5 |
| Table, Tab and List Schedule Views | 2.2.8 | with Grid, Calendar and View Switching | 2.3.4 |
| Weekly Show Shifts and Date Overrides | 2.2.8 | with Recurring Periodic Overrides | 2.6.0 |
| CONTENT |
| Show Posts and Linked Overrides | 2.2.8 | with Show Episodes Post Type | 2.4.1 |
| Playlist with Track Editor | 2.2.8 | **Show Episode Segment Editor** | |
| Archive Shortcodes with Automatic Pages | 2.3.0 | with Episode and Team Archives | 2.4.1.8 |
| Show Page Display Template | 2.3.0 | with Social Icons | 2.3.5 |
| Show Hosts and Producers | 2.2.8 | with Profile Page Templates | 2.4.1 |
| PLAYER |
| Streaming Player Widget/Shortcode | 2.3.4 | with Sitewide Persistant Player Bar | 2.4.1 |
| Player Theme and Button Options | 2.3.4 | with Extra Skin and Color Options | 2.6.0 |
| *File Playing Support and Buttons* | | *with Playlist Track Support* | |
| WIDGETS/SHORTCODES |
| Radio Blocks (Gutenberg Block Editor) | 2.5.0 | Elementor and Beaver Builder Modules | 2.6.0 |
| Show Widget/Shortcodes with Countdowns | 2.2.8 | with Dynamic Reloading | 2.4.1 |
| Current Playlist Widget/Shortcode | 2.2.8 | Player Track Metadata Display | 2.4.1.3 |
| Radio Clock Widget/Shortcode | 2.3.2 | with User Timezone Switcher | 2.4.1 |
| EXTRAS |
| Host / Producer / Show Editor Roles | 2.3.0 | with Role Assignment Interface | 2.3.0 |
| REST/Feed API Endpoints | 2.3.0 | with Episodes, Hosts and Producers | 2.4.1 |
| Standard HTML Markup Output | 2.3.0 | *with SEO Schema Markup* | |
| Show Genre Assignments | 2.2.8 | Episode Guests and Topics | 2.4.1 |


[comment]: # (Show and Override Feeds)

Interested in going Pro? For a full feature list comparison, [click here to find out more about Radio Station Pro](https://radiostation.pro/pricing/).
