# Radio Station Pro Documentation

*** 

Pro Feature Documentation is included where relevant within the existing Free version documentation, marked with `[Pro]`.

But in order to find the Pro feature documentation more easily, an index is provided here linking to each of those sections.

Note that additional Pro Documentation will be added in the relevant section as new Features are released into the Pro version. 

If you are interested in testing cutting edge features in development for this next release, read about [Installing the Development Version](./FAQ.md#how-do-i-install-the-latest-development-version-for-testing) and [Pro Beta Version Testing](./#pro-beta-version-testing).


### Radio Station Plus

Please note that the following features are *not* available in Radio Station Plus:

- Persistent Stream Player Bar (and related features)
- Visual Schedule Editor Interface
- Episodes and Segments (and related data/features)
- Page Builder Modules (for Elementor and Beaver Builder)


### PRO Plugin Features

#### API

[Episodes Data Endpoint](./API.md#pro-episodes-endpoint)

[Hosts Data Endpoint](./API.md#pro-hosts-endpoint)

[Producers Data Endpoint](./API.md#pro-producers-endpoint)

#### Data

[Show Episodes](./Data.md#pro-show-episodes)

[Host and Producer Profiles](./Data.md#pro-host-and-producer-profiles)

#### Display

[Profile Images](./Display.md#pro-profile-images)

[Genre Images and Colors](./Display.md#genre-images-and-colors)

#### Filters

[Pro Filters List](./Filters.md#pro-pro-filter-list)

#### Manage

[Visual Shift Editor](./Manage.md#pro-visual-shift-editor)

#### Options

[Pro Options](./Options.md) (marked throughout options list)

#### Roles

[Role Editor Interface](./Roles.md#pro-role-editor-interface)

#### Shortcodes

[Schedule Grid View](./Shortcodes.md#master-schedule-shortcode)

[Schedule Calendar View](./Shortcodes.md#master-schedule-shortcode)

[Multiple View Switching](./Shortcodes.md#pro-multiple-view-switching)

[Timezone Switching](./Shortcodes.md#pro-user-timezone-switching)

[Hosts Archive Shortcode](./Shortcodes.md#pro-hosts-archive-shortcode)

[Producers Archive Shortcode](./Shortcodes.md#pro-producers-archive-shortcode)

[Team Archive Shortcode](./Shortcodes.md#pro-team-archive-shortcode)

[Show Episodes Archive Shortcode](./Shortcodes.md#pro-show-episodes-archive-shortcode)

#### Widgets

[Timezone Switcher](./Widgets.md#pro-timezone-switcher)

[Extra Block Options](./Widgets.md#pro-extra-block-options)

[Elementor Widgets](./Widgets.md#pro-elementor-widgets)

[Beaver Builder Modules]('./Widgets.md#pro-beaver-builder-modules)


### Pro Player Features

[Extra Widget and Shortcode Options](./Player.md#pro-extra-widget-and-shortcode-options)

[Extra Block Options](./Player.md#pro-extra-block-options)

[Sitewide Bar Player](./Player.md#pro-sitewide-bar-player)

[Responsive Bar Display](./Player.md#pro-responsive-bar-display)

[Continous Player Integration](./Player.md#pro-continuous-player-integration)

[Smooth Page Transitions](./Player.md#pro-smooth-page-transitions)

[Extra Bar Color Options](./Player.md#pro-extra-bar-color-options)

[Playback AutoResume](./Player.md#pro-playback-autoresume)

[Popup Player](./Player.md#pro-popup-player)

[Track Metadata](./Player.md#pro-track-metadata)

[Elementor Widget](./Player.md#pro-elementor-widget)

[Beaver Builder Module]('./Player.md#pro-beaver-builder-module)
